<?php
if (!defined('ABSPATH')) exit;

add_action('init', function() {
    $labels = [
        'name' => 'WarForms',
        'singular_name' => 'WarForm',
        'add_new' => 'Add New',
        'add_new_item' => 'Add New WarForm',
        'edit_item' => 'Edit WarForm',
        'new_item' => 'New WarForm',
        'view_item' => 'View WarForm',
        'search_items' => 'Search WarForms',
        'not_found' => 'No WarForms found',
        'menu_name' => 'WarForms',
    ];

    register_post_type('warform', [
        'labels' => $labels,
        'public' => false,
        'show_ui' => true,
        'show_in_menu' => true,
        'menu_position' => 26,
        'menu_icon' => 'data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyNCAyNCIgYXJpYS1oaWRkZW49InRydWUiPgogIDxwYXRoIGZpbGw9ImN1cnJlbnRDb2xvciIgZD0iTTYgM2g5bDMgM3YxNWEyIDIgMCAwIDEtMiAySDZhMiAyIDAgMCAxLTItMlY1YTIgMiAwIDAgMSAyLTJ6Ii8+CiAgPHBhdGggZmlsbD0iY3VycmVudENvbG9yIiBvcGFjaXR5PSIwLjM1IiBkPSJNMTUgM3Y0aDR6Ii8+CiAgPHBhdGggZmlsbD0ibm9uZSIgc3Ryb2tlPSJjdXJyZW50Q29sb3IiIHN0cm9rZS13aWR0aD0iMiIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIgogICAgICAgIGQ9Ik03IDEybDEuNiA3TDExIDE1bDIuNCA0IDEuNi03Ii8+CiAgPHBhdGggZmlsbD0ibm9uZSIgc3Ryb2tlPSJjdXJyZW50Q29sb3IiIHN0cm9rZS13aWR0aD0iMiIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIgogICAgICAgIGQ9Ik03LjUgOC41aDkiLz4KPC9zdmc+Cg==',
        'supports' => ['title'],
        'has_archive' => false,
        'show_in_rest' => false, // we intentionally use Classic Editor for reliability
    ]);
});

// Force Classic Editor for this CPT so schema meta posts reliably.
add_filter('use_block_editor_for_post_type', function($use_block_editor, $post_type) {
    if ($post_type === 'warform') return false;
    return $use_block_editor;
}, 10, 2);

// Add a small Diagnostics submenu (optional but helpful).
add_action('admin_menu', function() {
    add_submenu_page(
        'edit.php?post_type=warform',
        'Diagnostics',
        'Diagnostics',
        'manage_options',
        'warforms-reboot-diagnostics',
        function() {
            if (!current_user_can('manage_options')) return;
            $last = warforms_reboot_get_last_error();
            echo '<div class="wrap"><h1>WarForms Diagnostics</h1>';
            echo '<p><strong>Plugin version:</strong> ' . esc_html(WARFORMS_REBOOT_VERSION) . '</p>';
            echo '<p><strong>WordPress:</strong> ' . esc_html(get_bloginfo('version')) . '</p>';
            echo '<p><strong>PHP:</strong> ' . esc_html(PHP_VERSION) . '</p>';
            echo '<h2>Last submit error</h2>';
            if (empty($last)) {
                echo '<p>No errors recorded.</p>';
            } else {
                echo '<ul>';
                echo '<li><strong>Time:</strong> ' . esc_html(date('Y-m-d H:i:s', intval($last['time'] ?? 0))) . '</li>';
                echo '<li><strong>Code:</strong> ' . esc_html($last['code'] ?? '') . '</li>';
                echo '<li><strong>Detail:</strong> ' . esc_html($last['detail'] ?? '') . '</li>';
                echo '</ul>';
            }
            echo '</div>';
        }
    );
});
